/*
 * Decompiled with CFR 0.152.
 */
package controller;

import dao.SpaceInvadersDAOText;
import dao.UserDetailsDAOText;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import model.AlienArmyArray;
import model.AlienEntity;
import model.AlienShotEntity;
import model.BorderEntity;
import model.Entity;
import model.EntityListArray;
import model.EntityListInterface;
import model.GameDetails;
import model.GameSettings;
import model.ShipEntity;
import model.ShotEntity;
import model.State;
import model.UserDetails;
import model.events.EntityDiedEvent;
import model.events.EntityEventListener;
import model.events.EntityHitEvent;
import model.events.EntityMoveEvent;
import view.UserEvent;
import view.UserEventListener;
import view.UserViewInterface;

public class Game
implements Runnable,
EntityEventListener,
UserEventListener {
    private List<EventObject> gameEvents = null;
    private BufferStrategy strategy;
    private boolean gameRunning = true;
    private ShipEntity ship;
    private AlienArmyArray aliens;
    private EntityListInterface shotsFiredByShip;
    private BorderEntity rightBorder;
    private BorderEntity leftBorder;
    private BorderEntity bottomBorder;
    private BorderEntity topBorder;
    private long lastPlayerFire = 0L;
    private long lastAlienFire = 0L;
    private boolean doubleShot = false;
    private boolean leftPressed = false;
    private boolean rightPressed = false;
    private boolean upPressed = false;
    private boolean downPressed = false;
    private boolean firePressed = false;
    private boolean paused = true;
    private Canvas gameCanvas;
    private JPanel theGamePanel;
    private GameDetails currentGame;
    private UserViewInterface theView;
    private Image backgroundImg;
    private boolean gameOver = false;

    public Game(UserDetails userDetails, GameSettings gameSettings, UserViewInterface userControlPanel) throws SQLException, Exception {
        this.theView = userControlPanel;
        this.theGamePanel = new JPanel();
        this.currentGame = new GameDetails(userDetails, gameSettings);
        this.currentGame.resetTheScoringDetails();
        this.theView.setUpForNewGame(this.currentGame);
        this.theView.adjustInterfaceOptionsDueToWantingIntroInfoChange(userDetails.isWantingIntroInfo());
        this.gameEvents = new LinkedList<EventObject>();
        this.theGamePanel.setPreferredSize(new Dimension(800, 520));
        this.theGamePanel.setLayout(null);
        this.gameCanvas = new Canvas();
        this.gameCanvas.setBounds(0, 0, 800, 520);
        this.gameCanvas.setVisible(true);
        this.theGamePanel.add(this.gameCanvas);
        this.backgroundImg = this.loadBG();
        this.loadBackGroundGameSound();
        this.gameCanvas.setIgnoreRepaint(true);
        this.gameCanvas.addKeyListener(new KeyInputHandler());
        this.setUpForNewGame();
    }

    private Image loadBG() {
        BufferedImage image = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("sprites/bg.gif");
            BufferedImage sourceImage = ImageIO.read(url);
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            image = gc.createCompatibleImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
            ((Image)image).getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        catch (IOException ex) {
            Logger.getLogger("SpaceInvadersLog").log(Level.SEVERE, "Unable to open background image file", ex);
        }
        return image;
    }

    private void loadBackGroundGameSound() {
    }

    @Override
    public void run() {
        this.gameLoop();
    }

    @Override
    public final void setUpForNewGame() {
        this.setPaused(true);
        this.gameEvents.clear();
        this.initEntities();
        this.leftPressed = false;
        this.rightPressed = false;
        this.upPressed = false;
        this.downPressed = false;
        this.firePressed = false;
        this.gameOver = false;
        try {
            this.currentGame.resetTheScoringDetails();
        }
        catch (Exception ex) {
            Logger.getLogger(Game.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.theView.setUpForNewGame(this.currentGame);
    }

    private void initEntities() {
        this.ship = new ShipEntity(370, 470);
        this.ship.addEntityEventListener(this);
        this.aliens = new AlienArmyArray(this, 5, 12);
        this.aliens.addEntityEventListener(this);
        this.shotsFiredByShip = new EntityListArray();
        this.shotsFiredByShip.addEntityEventListener(this);
        this.rightBorder = new BorderEntity("RIGHT", 800, 0, 10, 650);
        this.rightBorder.addEntityEventListener(this);
        this.leftBorder = new BorderEntity("LEFT", 0, 0, 10, 650);
        this.leftBorder.addEntityEventListener(this);
        this.bottomBorder = new BorderEntity("BOTTOM", 0, 510, 850, 10);
        this.bottomBorder.addEntityEventListener(this);
        this.topBorder = new BorderEntity("TOP", 0, 0, 850, 10);
        this.topBorder.addEntityEventListener(this);
    }

    private void checkForCollision(EntityMoveEvent e) {
        Entity otherEntity = null;
        Entity theEntity = e.getEntity();
        if (theEntity instanceof AlienEntity) {
            otherEntity = this.checkAlienMoveCollision((AlienEntity)theEntity);
        } else if (theEntity instanceof ShipEntity) {
            otherEntity = this.checkShipMoveCollision((ShipEntity)theEntity);
        } else if (theEntity instanceof ShotEntity) {
            otherEntity = this.checkShotMoveCollision((ShotEntity)theEntity);
        }
        if (otherEntity != null) {
            if (theEntity instanceof ShipEntity) {
                theEntity.fireCollisionHasOccured(new EntityHitEvent(theEntity, otherEntity));
                otherEntity.fireCollisionHasOccured(new EntityHitEvent(otherEntity, theEntity));
            } else {
                otherEntity.fireCollisionHasOccured(new EntityHitEvent(otherEntity, theEntity));
                theEntity.fireCollisionHasOccured(new EntityHitEvent(theEntity, otherEntity));
            }
        }
        this.checkCollisionsWithBorders(theEntity);
    }

    private Entity checkShotMoveCollision(ShotEntity shotEntity) {
        Entity collidedWith = null;
        if (shotEntity instanceof AlienShotEntity) {
            if (shotEntity.collidesWith(this.ship)) {
                collidedWith = this.ship;
            }
            if (collidedWith == null) {
                collidedWith = this.shotsFiredByShip.collidesWith(shotEntity);
            }
        } else {
            collidedWith = this.aliens.collidesWith(shotEntity);
        }
        return collidedWith;
    }

    private Entity checkAlienMoveCollision(AlienEntity theAlien) {
        Entity collidedWith = null;
        if (theAlien.collidesWith(this.ship)) {
            collidedWith = this.ship;
        }
        if (collidedWith == null && (collidedWith = this.shotsFiredByShip.collidesWith(theAlien)) instanceof AlienShotEntity) {
            collidedWith = null;
        }
        return collidedWith;
    }

    private Entity checkShipMoveCollision(ShipEntity ship) {
        Entity collidedWith = this.aliens.collidesWith(ship);
        if (collidedWith == null) {
            collidedWith = this.shotsFiredByShip.collidesWith(ship);
        }
        return collidedWith;
    }

    private void checkCollisionsWithBorders(Entity entity) {
        if (entity.collidesWith(this.rightBorder)) {
            entity.fireCollisionHasOccured(new EntityHitEvent(entity, this.rightBorder));
            this.rightBorder.fireCollisionHasOccured(new EntityHitEvent(this.rightBorder, entity));
        }
        if (entity.collidesWith(this.leftBorder)) {
            entity.fireCollisionHasOccured(new EntityHitEvent(entity, this.leftBorder));
            this.leftBorder.fireCollisionHasOccured(new EntityHitEvent(this.leftBorder, entity));
        }
        if (entity.collidesWith(this.bottomBorder)) {
            entity.fireCollisionHasOccured(new EntityHitEvent(entity, this.bottomBorder));
            this.bottomBorder.fireCollisionHasOccured(new EntityHitEvent(this.bottomBorder, entity));
        }
        if (entity.collidesWith(this.topBorder)) {
            entity.fireCollisionHasOccured(new EntityHitEvent(entity, this.topBorder));
            this.topBorder.fireCollisionHasOccured(new EntityHitEvent(this.topBorder, entity));
        }
    }

    public void tryToFire() {
        if (System.currentTimeMillis() - this.lastPlayerFire < (long)this.currentGame.getGameSettings().getFiringInterval()) {
            return;
        }
        this.lastPlayerFire = System.currentTimeMillis();
        int shotLocationX = this.ship.getX() + this.ship.getSprite().getWidth() / 2;
        int shotLocationY = this.ship.getY() - (this.ship.getSprite().getHeight() + 10);
        if (this.doubleShot) {
            ShotEntity shot = new ShotEntity(shotLocationX, shotLocationY);
            this.shotsFiredByShip.add(shot);
            shot = new ShotEntity(shotLocationX + 20, shotLocationY);
            this.shotsFiredByShip.add(shot);
            this.currentGame.setShotsFired(this.currentGame.getShotsFired() + 2);
        } else {
            ShotEntity shot = new ShotEntity(shotLocationX, shotLocationY);
            this.shotsFiredByShip.add(shot);
            shot.addEntityEventListener(this);
            this.currentGame.setShotsFired(this.currentGame.getShotsFired() + 1);
        }
        this.currentGame.setScore(this.currentGame.calculateScoreChanges());
        this.theView.displayGameDetails();
    }

    public void randomAlienFire() {
        if (System.currentTimeMillis() - this.lastAlienFire < 1000L) {
            return;
        }
        this.lastAlienFire = System.currentTimeMillis();
        Entity alien = this.aliens.getRandom();
        if (alien != null) {
            AlienShotEntity shot = new AlienShotEntity(alien.getX() + 10, alien.getY() + 10, 300.0);
            this.shotsFiredByShip.add(shot);
            shot.addEntityEventListener(this);
        }
    }

    public void gameLoop() {
        long lastLoopTime = System.currentTimeMillis();
        this.gameCanvas.createBufferStrategy(2);
        this.strategy = this.gameCanvas.getBufferStrategy();
        while (this.gameRunning) {
            long delta = System.currentTimeMillis() - lastLoopTime;
            lastLoopTime = System.currentTimeMillis();
            if (this.isPaused()) {
                delta = 0L;
            } else {
                this.gameCanvas.requestFocus();
            }
            Graphics2D g = (Graphics2D)this.strategy.getDrawGraphics();
            if (this.backgroundImg == null) {
                g.setColor(Color.black);
                g.fillRect(0, 0, 800, 520);
            } else {
                g.drawImage(this.backgroundImg, 0, 0, null);
            }
            if (delta != 0L) {
                this.ship.updateState(delta);
                this.aliens.updateState(delta);
                this.shotsFiredByShip.updateState(delta);
            }
            this.ship.draw(g);
            this.aliens.draw(g);
            this.shotsFiredByShip.draw(g);
            this.bottomBorder.draw(g);
            g.dispose();
            this.strategy.show();
            this.processGameEvents();
            this.ship.setHorizontalMovement(0.0);
            this.ship.setVerticalMovement(0.0);
            double moveSpeed = this.currentGame.getGameSettings().getMoveSpeed();
            if (this.leftPressed && !this.rightPressed) {
                this.ship.setHorizontalMovement(-moveSpeed);
            } else if (this.rightPressed && !this.leftPressed) {
                this.ship.setHorizontalMovement(moveSpeed);
            } else if (this.upPressed && !this.downPressed) {
                this.ship.setVerticalMovement(-moveSpeed);
            } else if (this.downPressed && !this.upPressed) {
                this.ship.setVerticalMovement(moveSpeed);
            }
            if (this.firePressed) {
                this.tryToFire();
            }
            if (this.isPaused()) continue;
            this.randomAlienFire();
        }
    }

    public JPanel getGamePanel() {
        return this.theGamePanel;
    }

    private void processGameEvents() {
        boolean weWon = false;
        int numEvents = this.gameEvents.size();
        this.gameOver = false;
        for (int i = 0; !this.gameOver && i < numEvents; ++i) {
            EventObject e = this.gameEvents.get(0);
            if (e instanceof EntityMoveEvent) {
                this.checkForCollision((EntityMoveEvent)e);
            }
            if (e instanceof EntityDiedEvent) {
                if (e.getSource() instanceof AlienEntity) {
                    this.currentGame.setShipsDestroyed(this.currentGame.getShipsDestroyed() + 1);
                    this.currentGame.setScore(this.currentGame.calculateScoreChanges());
                    this.theView.displayGameDetails();
                    if (this.aliens.getNumEntities() == 0) {
                        this.gameOver = true;
                        weWon = true;
                    }
                } else if (e.getSource() instanceof ShipEntity && ((Entity)e.getSource()).getCurrentState() == State.DEAD) {
                    this.gameOver = true;
                    weWon = false;
                }
            }
            this.gameEvents.remove(0);
        }
        if (this.gameOver) {
            if (weWon) {
                this.theView.notifyWin();
            } else if (this.ship.getCurrentState() == State.DEAD) {
                this.theView.notifyDeath();
            } else {
                this.theView.notifyGameOver();
            }
            if (this.currentGame.isNewHighScore()) {
                this.theView.notifyNewHighScore();
                this.saveCurrentGameResults(new UserEvent(this));
            }
            this.setUpForNewGame();
        }
    }

    @Override
    public void entityDied(EntityDiedEvent e) {
        this.gameEvents.add(e);
    }

    @Override
    public void entityMoved(EntityMoveEvent e) {
        this.gameEvents.add(e);
    }

    @Override
    public void collisionHasOccured(EntityHitEvent e) {
        if (e.getHitBy() == this.bottomBorder && e.getHit() instanceof AlienEntity || e.getHitBy() instanceof AlienEntity && e.getHit() == this.bottomBorder) {
            this.gameEvents.add(new EntityDiedEvent(this.ship));
        }
    }

    @Override
    public void exitGame(UserEvent e) {
        this.gameRunning = false;
        this.endGame();
    }

    @Override
    public void startPlaying(UserEvent e) {
        this.gameCanvas.requestFocusInWindow();
        this.gameCanvas.requestFocus();
        this.setPaused(false);
    }

    @Override
    public void pauseGame(UserEvent e) {
        this.setPaused(true);
    }

    @Override
    public void saveCurrentGameResults(UserEvent e) {
        this.saveCurrentGameResults();
    }

    private void saveCurrentGameResults() {
        try {
            if (this.currentGame.calculateScoreChanges() > this.currentGame.getHighScore()) {
                this.currentGame.setHighScore(this.currentGame.calculateScoreChanges());
            }
            this.currentGame.saveData();
            this.theView.displayGameDetails();
        }
        catch (Exception Ex) {
            this.theView.displaySaveGameSettingsError();
        }
    }

    @Override
    public void changeFiringInterval(UserEvent e) {
        this.currentGame.getGameSettings().setFiringInterval(e.getFiringInterval());
        this.currentGame.setHighScore(0);
        this.setUpForNewGame();
    }

    @Override
    public void changeMoveSpeed(UserEvent e) {
        if (Math.abs(e.getMoveSpeed() - this.currentGame.getGameSettings().getMoveSpeed()) >= 0.01) {
            this.currentGame.getGameSettings().setMoveSpeed(e.getMoveSpeed());
            this.currentGame.setHighScore(0);
            this.setUpForNewGame();
        }
    }

    private void endGame() {
        System.exit(0);
    }

    @Override
    public void undoLastSave(UserEvent userEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getUsersHighScores(UserEvent userEvent) throws Exception {
        try {
            UserDetails theUser = new UserDetails(userEvent.getUserName());
            List<GameDetails> highScores = UserDetailsDAOText.getHighScores(theUser);
            this.theView.displayUsersHighScores(theUser, highScores);
        }
        catch (SQLException ex) {
            this.theView.displayErrorDatabaseConnectionLost();
        }
    }

    @Override
    public void getAllHighScores() {
        try {
            List<GameDetails> allHighScores = SpaceInvadersDAOText.getGameHighScores();
            this.theView.displayAllHighScores(allHighScores);
        }
        catch (Exception ex) {
            this.theView.displayErrorDatabaseConnectionLost();
        }
    }

    @Override
    public void changeSettingForWantingIntroInfo(boolean wantIntroInfo) {
        UserDetails theUser = this.currentGame.getUserDetails();
        try {
            theUser.setWantingIntroInfo(wantIntroInfo);
            theUser.saveData();
            this.theView.adjustInterfaceOptionsDueToWantingIntroInfoChange(wantIntroInfo);
        }
        catch (Exception ex) {
            String message = " when trying to turn intro info " + (theUser.isWantingIntroInfo() ? " on" : " off");
            this.theView.displayErrorUnableToSaveUserDetails(message);
            Logger.getLogger("SpaceInvadersLog").log(Level.SEVERE, "Could not save user details during organiseForNoMoreIntroScreen - " + message, ex);
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    private class KeyInputHandler
    extends KeyAdapter {
        private KeyInputHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (Game.this.paused) {
                return;
            }
            if (e.getKeyCode() == 38) {
                Game.this.upPressed = true;
            }
            if (e.getKeyCode() == 40) {
                Game.this.downPressed = true;
            }
            if (e.getKeyCode() == 37) {
                Game.this.leftPressed = true;
            }
            if (e.getKeyCode() == 39) {
                Game.this.rightPressed = true;
            }
            if (e.getKeyCode() == 32) {
                Game.this.firePressed = true;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (Game.this.paused) {
                return;
            }
            if (e.getKeyCode() == 38) {
                Game.this.upPressed = false;
            }
            if (e.getKeyCode() == 40) {
                Game.this.downPressed = false;
            }
            if (e.getKeyCode() == 37) {
                Game.this.leftPressed = false;
            }
            if (e.getKeyCode() == 39) {
                Game.this.rightPressed = false;
            }
            if (e.getKeyCode() == 32) {
                Game.this.firePressed = false;
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u001b') {
                Game.this.endGame();
            }
        }
    }
}

