/*
 * Decompiled with CFR 0.152.
 */
package controller;

import dao.GameSettingsDAOText;
import dao.UserDetailsDAOText;
import model.GameSettings;
import model.UserDetails;
import view.JDialogLogin;

public class LoginController {
    private UserDetails user;
    private JDialogLogin dlgLogin;
    private boolean databaseError = false;
    private boolean successfulLogin = false;
    private boolean loginCancelled = false;

    public LoginController(UserDetails user, JDialogLogin dlg) {
        this.user = user;
        this.dlgLogin = dlg;
    }

    public void login() {
        do {
            this.databaseError = false;
            this.dlgLogin.setVisible(true);
            if (this.dlgLogin.isLoginCancelled()) {
                this.loginCancelled = true;
                continue;
            }
            if (this.dlgLogin.getPlayerType() == 1) {
                this.createNewUser();
                continue;
            }
            this.verifyLogin();
        } while (!this.loginCancelled && !this.successfulLogin && !this.databaseError);
    }

    private void verifyLogin() {
        try {
            this.user.setUserName(this.dlgLogin.getUsername());
            this.user.loadData();
            if (this.user.getPassword() == null) {
                this.successfulLogin = false;
                this.dlgLogin.displayUserDoesNotExistError();
            } else {
                this.successfulLogin = this.user.getPassword().equals(this.dlgLogin.getPassword());
                if (!this.successfulLogin) {
                    this.dlgLogin.displayWrongPasswordError();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.databaseError = true;
            this.dlgLogin.displayDatabaseError();
        }
    }

    private void createNewUser() {
        try {
            this.user.setUserName(this.dlgLogin.getUsername());
            this.user.loadData();
            if (this.user.getPassword() != null) {
                this.successfulLogin = false;
                this.dlgLogin.displayUserAlreadyExistsError();
            } else {
                this.user.setPassword(this.dlgLogin.getPassword());
                UserDetailsDAOText.saveData(this.user);
                GameSettingsDAOText.saveData(this.user, new GameSettings());
                this.successfulLogin = true;
            }
        }
        catch (Exception ex) {
            this.databaseError = true;
            this.dlgLogin.displayDatabaseError();
        }
    }

    public boolean isDatabaseError() {
        return this.databaseError;
    }

    public boolean isSuccessfulLogin() {
        return this.successfulLogin;
    }

    public boolean isLoginCancelled() {
        return this.loginCancelled;
    }

    public UserDetails getUser() {
        return this.user;
    }
}

