/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.Game;
import controller.LoginController;
import controller.MyLogger;
import dao.SpaceInvadersDAOText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import model.GameSettings;
import model.UserDetails;
import view.JDialogLogin;
import view.UserView;

public class StartApplication {
    static MyLogger theLogger;
    private static UserView userControlView;

    public static void main(String[] argv) throws Exception {
        Game theGame = null;
        try {
            theLogger = new MyLogger();
        }
        catch (IOException ex) {
            Logger.getLogger(StartApplication.class.getName()).log(Level.SEVERE, "Couldn't create spaceinvaders logger", ex);
        }
        Logger.getLogger("SpaceInvadersLog").log(Level.INFO, "Starting SpaceInvaders...");
        Logger.getLogger("SpaceInvadersLog").setLevel(Level.INFO);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        JFrame frameForWholeGame = new JFrame("Space Invaders TAFE SA");
        frameForWholeGame.setDefaultCloseOperation(3);
        frameForWholeGame.setLayout(new BorderLayout());
        userControlView = new UserView(frameForWholeGame);
        GameSettings gameSettings = new GameSettings();
        UserDetails userDetails = new UserDetails();
        try {
            SpaceInvadersDAOText.connectToSpaceInvadersDatabase();
            Logger.getLogger("SpaceInvadersLog").log(Level.INFO, "Connected to DB...");
            JDialogLogin dlgLogin = new JDialogLogin(frameForWholeGame);
            dlgLogin.setLocation(400, 200);
            LoginController loginController = new LoginController(userDetails, dlgLogin);
            Logger.getLogger("SpaceInvadersLog").log(Level.INFO, "Logging in...");
            loginController.login();
            if (loginController.isLoginCancelled()) {
                System.exit(0);
            } else if (loginController.isDatabaseError()) {
                userControlView.displayErrorDatabaseConnectionLost();
            } else {
                gameSettings.loadData(userDetails);
            }
        }
        catch (Exception ex) {
            Logger.getLogger("SpaceInvadersLog").log(Level.SEVERE, "During login...", ex);
            userControlView.displayErrorDatabaseConnectionLost();
        }
        try {
            theGame = new Game(userDetails, gameSettings, userControlView);
        }
        catch (SQLException ex) {
            userControlView.displayErrorDatabaseConnectionLost();
            Logger.getLogger("SpaceInvadersLog").log(Level.SEVERE, "Lost database during creation of the game object.", ex);
        }
        Logger.getLogger("SpaceInvadersLog").log(Level.INFO, "USER Logged in...[{0}]", userDetails.getUserName());
        frameForWholeGame.add((Component)theGame.getGamePanel(), "Center");
        frameForWholeGame.add((Component)userControlView, "South");
        userControlView.setController(theGame);
        frameForWholeGame.pack();
        frameForWholeGame.setResizable(false);
        Logger.getLogger("SpaceInvadersLog").log(Level.INFO, "About to make View visible..");
        frameForWholeGame.setVisible(true);
        if (userDetails.isWantingIntroInfo()) {
            userControlView.displayIntroductionInfo();
        }
        frameForWholeGame.requestFocus();
        Thread gameThread = new Thread(theGame);
        Logger.getLogger("SpaceInvadersLog").log(Level.INFO, "About to start game thread..");
        gameThread.start();
    }
}

