/*
 * Decompiled with CFR 0.152.
 */
package dao;

import dao.GameSettingsDAOText;
import dao.SpaceInvadersDAOText;
import dao.UserDetailsDAOText;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.GameDetails;
import model.GameSettings;

public class GameDetailsDAOText
extends SpaceInvadersDAOText {
    public static boolean saveData(GameDetails gameDetails) throws Exception {
        UserDetailsDAOText.saveData(gameDetails.getUserDetails());
        GameSettingsDAOText.saveData(gameDetails.getUserDetails(), gameDetails.getGameSettings());
        boolean saveResult = GameDetailsDAOText.saveHighScore(gameDetails);
        return saveResult;
    }

    public static boolean loadData(GameDetails gameDetails) throws Exception {
        UserDetailsDAOText.loadData(gameDetails.getUserDetails());
        GameSettingsDAOText.loadData(gameDetails.getUserDetails(), gameDetails.getGameSettings());
        return true;
    }

    public static boolean saveHighScore(GameDetails gameDetails) throws IOException {
        int firingInterval;
        double moveSpeed;
        String userName;
        boolean needToAddNewEntry = true;
        boolean deleteSuccess = false;
        int highScoreInGameDetailsObject = gameDetails.getHighScore();
        File tempHighScoresFile = new File("temp_highscores.csv");
        FileWriter outFileWriter = new FileWriter(tempHighScoresFile);
        PrintWriter tempHighScoreFilePW = new PrintWriter(outFileWriter);
        try {
            boolean finished;
            BufferedReader userHighScoresFile = GameDetailsDAOText.getUserHighScoresInputConnection();
            String aLine = userHighScoresFile.readLine();
            boolean bl = finished = aLine == null;
            while (!finished) {
                userName = aLine.split(",")[0];
                moveSpeed = Double.parseDouble(aLine.split(",")[1]);
                firingInterval = Integer.parseInt(aLine.split(",")[2]);
                int highScoreInFile = Integer.parseInt(aLine.split(",")[3]);
                if (userName.equals(gameDetails.getUserDetails().getUserName()) & moveSpeed == gameDetails.getGameSettings().getMoveSpeed() & firingInterval == gameDetails.getGameSettings().getFiringInterval()) {
                    needToAddNewEntry = false;
                    if (highScoreInGameDetailsObject > highScoreInFile) {
                        tempHighScoreFilePW.write(userName + "," + moveSpeed + "," + firingInterval + "," + highScoreInGameDetailsObject + "\n");
                    } else {
                        tempHighScoreFilePW.write(userName + "," + moveSpeed + "," + firingInterval + "," + highScoreInFile + "\n");
                    }
                } else {
                    tempHighScoreFilePW.write(aLine + "\n");
                }
                if (finished) continue;
                aLine = userHighScoresFile.readLine();
                finished = aLine == null;
            }
            userHighScoresFile.close();
        }
        catch (FileNotFoundException e) {
            Logger.getLogger("SpaceInvadersLog").log(Level.INFO, "High Score CSV does not exist , will be created...");
        }
        if (needToAddNewEntry) {
            userName = gameDetails.getUserDetails().getUserName();
            firingInterval = gameDetails.getGameSettings().getFiringInterval();
            moveSpeed = gameDetails.getGameSettings().getMoveSpeed();
            tempHighScoreFilePW.println(userName + "," + moveSpeed + "," + firingInterval + "," + highScoreInGameDetailsObject);
        }
        tempHighScoreFilePW.close();
        deleteSuccess = GameDetailsDAOText.myDelete(new File("user_high_scores.csv"));
        tempHighScoresFile.renameTo(new File("user_high_scores.csv"));
        return deleteSuccess;
    }

    public static void loadHighScore(GameDetails gameDetails) throws Exception {
        boolean finished;
        BufferedReader userHighScoresFile = GameDetailsDAOText.getUserHighScoresInputConnection();
        String aLine = userHighScoresFile.readLine();
        boolean bl = finished = aLine == null;
        while (!finished) {
            StringTokenizer gameDetailsTok = new StringTokenizer(aLine, ",");
            String userName = gameDetailsTok.nextToken();
            double moveSpeed = Double.parseDouble(gameDetailsTok.nextToken());
            int firingInterval = Integer.parseInt(gameDetailsTok.nextToken());
            GameSettings gameSettings = new GameSettings(moveSpeed, firingInterval);
            int savedHighScore = Integer.parseInt(gameDetailsTok.nextToken());
            if (userName.equals(gameDetails.getUserDetails().getUserName()) && gameSettings.equals(gameDetails.getGameSettings())) {
                gameDetails.setHighScore(savedHighScore);
                finished = true;
            }
            if (finished) continue;
            aLine = userHighScoresFile.readLine();
            finished = aLine == null;
        }
        userHighScoresFile.close();
    }
}

