/*
 * Decompiled with CFR 0.152.
 */
package dao;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.GameDetails;
import model.GameSettings;
import model.UserDetails;

public class SpaceInvadersDAOText {
    public static final String SPACEINVADERS_USERS_DB_NAME = "users.csv";
    public static final String SPACEINVADERS_SETTINGS_DB_NAME = "settings.csv";
    public static final String SPACEINVADERS_USER_HIGH_SCORES_DB_NAME = "user_high_scores.csv";

    public static void connectToSpaceInvadersDatabase() throws FileNotFoundException, IOException {
        SpaceInvadersDAOText.getUserHighScoresInputConnection();
        SpaceInvadersDAOText.getSettingsInputConnection();
        SpaceInvadersDAOText.getUserHighScoresInputConnection();
    }

    public static BufferedReader getUsersInputConnection() throws FileNotFoundException, IOException {
        File spaceInvadersUsersFile = null;
        BufferedReader userOIS = null;
        spaceInvadersUsersFile = new File(SPACEINVADERS_USERS_DB_NAME);
        if (!spaceInvadersUsersFile.exists()) {
            new PrintWriter(spaceInvadersUsersFile).close();
            System.gc();
        }
        userOIS = new BufferedReader(new FileReader(spaceInvadersUsersFile));
        return userOIS;
    }

    public static BufferedReader getSettingsInputConnection() throws FileNotFoundException, IOException {
        File spaceInvadersSettingsFile = null;
        BufferedReader settingsOIS = null;
        spaceInvadersSettingsFile = new File(SPACEINVADERS_SETTINGS_DB_NAME);
        if (!spaceInvadersSettingsFile.exists()) {
            new PrintWriter(spaceInvadersSettingsFile).close();
            System.gc();
        }
        settingsOIS = new BufferedReader(new FileReader(spaceInvadersSettingsFile));
        return settingsOIS;
    }

    public static BufferedReader getUserHighScoresInputConnection() throws FileNotFoundException, IOException {
        File spaceInvadersUserHighScoresFile = null;
        BufferedReader userHighScoreOIS = null;
        spaceInvadersUserHighScoresFile = new File(SPACEINVADERS_USER_HIGH_SCORES_DB_NAME);
        if (!spaceInvadersUserHighScoresFile.exists()) {
            new PrintWriter(spaceInvadersUserHighScoresFile).close();
            System.gc();
        }
        userHighScoreOIS = new BufferedReader(new FileReader(spaceInvadersUserHighScoresFile));
        return userHighScoreOIS;
    }

    public static List<GameDetails> getGameHighScores() throws Exception {
        HashMap<GameSettings, GameDetails> gameHighScoresMap = new HashMap<GameSettings, GameDetails>();
        ArrayList<GameDetails> gameHighScoresList = new ArrayList<GameDetails>();
        BufferedReader userHighScoresFile = SpaceInvadersDAOText.getUserHighScoresInputConnection();
        String aLine = userHighScoresFile.readLine();
        while (aLine != null) {
            StringTokenizer gameDetailsTok = new StringTokenizer(aLine, ",");
            String userName = gameDetailsTok.nextToken();
            double moveSpeed = Double.parseDouble(gameDetailsTok.nextToken());
            int firingInterval = Integer.parseInt(gameDetailsTok.nextToken());
            GameSettings gameSettings = new GameSettings(moveSpeed, firingInterval);
            int savedHighScore = Integer.parseInt(gameDetailsTok.nextToken());
            if (gameHighScoresMap.containsKey(gameSettings)) {
                GameDetails gameDetails = (GameDetails)gameHighScoresMap.get(gameSettings);
                if (savedHighScore > gameDetails.getHighScore()) {
                    gameHighScoresMap.put(gameSettings, new GameDetails(new UserDetails(userName), gameSettings));
                }
            } else {
                gameHighScoresMap.put(gameSettings, new GameDetails(new UserDetails(userName), gameSettings));
            }
            aLine = userHighScoresFile.readLine();
        }
        for (GameSettings gs : gameHighScoresMap.keySet()) {
            gameHighScoresList.add((GameDetails)gameHighScoresMap.get(gs));
        }
        Collections.sort(gameHighScoresList, new HighScoresComparator());
        return gameHighScoresList;
    }

    public static boolean myDelete(File aFile) {
        int tries = 0;
        boolean success = aFile.delete();
        while (!success && tries < 20) {
            ++tries;
            try {
                System.gc();
                System.runFinalization();
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            success = aFile.delete();
        }
        if (!success) {
            Logger.getLogger("SpaceInvadersLog").log(Level.SEVERE, "Unable to delete file-> " + aFile.getName() + ". Probably locked by another application.");
        }
        return success;
    }

    static class HighScoresComparator
    implements Comparator {
        HighScoresComparator() {
        }

        public int compare(Object o1, Object o2) {
            GameDetails g1 = (GameDetails)o1;
            GameDetails g2 = (GameDetails)o2;
            int result = g1.getGameSettings().getMoveSpeed() > g2.getGameSettings().getMoveSpeed() ? 1 : (g1.getGameSettings().getMoveSpeed() < g2.getGameSettings().getMoveSpeed() ? -1 : (g1.getGameSettings().getFiringInterval() > g2.getGameSettings().getFiringInterval() ? 1 : (g1.getGameSettings().getFiringInterval() < g2.getGameSettings().getFiringInterval() ? -1 : 0)));
            return result;
        }
    }
}

