/*
 * Decompiled with CFR 0.152.
 */
package dao;

import dao.SpaceInvadersDAOText;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import model.GameDetails;
import model.GameSettings;
import model.UserDetails;

public class UserDetailsDAOText
extends SpaceInvadersDAOText {
    public static void loadData(UserDetails userWanted) throws IOException {
        boolean finished;
        BufferedReader userFile = UserDetailsDAOText.getUsersInputConnection();
        String aLine = userFile.readLine();
        boolean bl = finished = aLine == null;
        while (!finished) {
            StringTokenizer userTokeniser = new StringTokenizer(aLine, ",");
            UserDetails userInputFromFile = new UserDetails();
            userInputFromFile.setUserName(userTokeniser.nextToken());
            userInputFromFile.setPassword(userTokeniser.nextToken());
            userInputFromFile.setWantingIntroInfo(Boolean.parseBoolean(userTokeniser.nextToken()));
            if (userInputFromFile.equals(userWanted)) {
                userWanted.setPassword(userInputFromFile.getPassword());
                userWanted.setWantingIntroInfo(userInputFromFile.isWantingIntroInfo());
                finished = true;
            }
            if (finished) continue;
            aLine = userFile.readLine();
            finished = aLine == null;
        }
        userFile.close();
        System.gc();
    }

    public static void saveData(UserDetails userToBeSaved) throws FileNotFoundException, IOException, ClassNotFoundException {
        boolean finished;
        File tempFile = new File("temp_users.csv");
        PrintWriter tempOutputFile = new PrintWriter(tempFile);
        BufferedReader userFile = UserDetailsDAOText.getUsersInputConnection();
        boolean needToAddUser = true;
        String aLine = userFile.readLine();
        boolean bl = finished = aLine == null;
        while (!finished) {
            StringTokenizer userTokeniser = new StringTokenizer(aLine, ",");
            UserDetails userInputFromFile = new UserDetails();
            userInputFromFile.setUserName(userTokeniser.nextToken());
            userInputFromFile.setPassword(userTokeniser.nextToken());
            userInputFromFile.setWantingIntroInfo(Boolean.parseBoolean(userTokeniser.nextToken()));
            if (userInputFromFile.equals(userToBeSaved)) {
                tempOutputFile.println(userToBeSaved.getUserName() + "," + userToBeSaved.getPassword() + "," + userToBeSaved.isWantingIntroInfo());
                needToAddUser = false;
            } else {
                tempOutputFile.println(aLine);
            }
            aLine = userFile.readLine();
            finished = aLine == null;
        }
        if (needToAddUser) {
            tempOutputFile.println(userToBeSaved.getUserName() + "," + userToBeSaved.getPassword() + "," + userToBeSaved.isWantingIntroInfo());
        }
        userFile.close();
        tempOutputFile.close();
        UserDetailsDAOText.myDelete(new File("users.csv"));
        tempFile.renameTo(new File("users.csv"));
    }

    public static List<GameDetails> getHighScores(UserDetails user) throws Exception {
        ArrayList<GameDetails> usersHighScoresList = new ArrayList<GameDetails>();
        BufferedReader userHighScoresFile = UserDetailsDAOText.getUserHighScoresInputConnection();
        String aLine = userHighScoresFile.readLine();
        while (aLine != null) {
            StringTokenizer gameDetailsTok = new StringTokenizer(aLine, ",");
            String userName = gameDetailsTok.nextToken();
            double moveSpeed = Double.parseDouble(gameDetailsTok.nextToken());
            int firingInterval = Integer.parseInt(gameDetailsTok.nextToken());
            GameSettings gameSettings = new GameSettings(moveSpeed, firingInterval);
            int savedHighScore = Integer.parseInt(gameDetailsTok.nextToken());
            if (userName.equals(user.getUserName())) {
                GameDetails gameDetails = new GameDetails(user, gameSettings);
                gameDetails.setHighScore(savedHighScore);
                usersHighScoresList.add(gameDetails);
            }
            aLine = userHighScoresFile.readLine();
        }
        userHighScoresFile.close();
        return usersHighScoresList;
    }
}

