/*
 * Decompiled with CFR 0.152.
 */
package model;

import controller.Game;
import model.AlienEntity;
import model.BorderEntity;
import model.Entity;
import model.EntityListArray;
import model.events.EntityDiedEvent;
import model.events.EntityEventListener;
import model.events.EntityHitEvent;
import model.events.EntityMoveEvent;

public class AlienArmyArray
extends EntityListArray
implements EntityEventListener {
    int rows;
    int cols;
    private static int INCREASE_MOVE_SPEED_PERCENT = 2;

    public AlienArmyArray(Game game, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                AlienEntity alien = new AlienEntity(100 + col * 50, 50 + row * 40);
                this.add(alien);
                alien.addEntityEventListener(this);
            }
        }
    }

    public void setAnimated(boolean value) {
        for (Entity entity : this.entities) {
            if (!(entity instanceof AlienEntity)) continue;
            AlienEntity alien = (AlienEntity)entity;
            alien.setAnimated(value);
        }
    }

    @Override
    public void entityMoved(EntityMoveEvent e) {
        AlienEntity alien;
        if (e.getEntity() instanceof AlienEntity && (alien = (AlienEntity)e.getEntity()).getY() >= 500) {
            this.registerEntityForRemoval(alien);
        }
    }

    @Override
    public void collisionHasOccured(EntityHitEvent e) {
        if (e.getHitBy() instanceof BorderEntity) {
            BorderEntity border = (BorderEntity)e.getHitBy();
            for (int i = 0; i < this.numEntities; ++i) {
                Entity entity = this.entities[i];
                if (border.getId().equals("RIGHT") && entity.getHorizontalMovement() > 0.0) {
                    entity.moveTo(entity.getX() - 10, entity.getY() + 20);
                    entity.setHorizontalMovement(-entity.getHorizontalMovement());
                    continue;
                }
                if (!border.getId().equals("LEFT") || !(entity.getHorizontalMovement() < 0.0)) continue;
                entity.moveTo(entity.getX() + 10, entity.getY() + 20);
                entity.setHorizontalMovement(-entity.getHorizontalMovement());
            }
        }
    }

    @Override
    public void entityDied(EntityDiedEvent e) {
        if (e.getEntity() instanceof AlienEntity) {
            AlienEntity alien = (AlienEntity)e.getEntity();
            this.registerEntityForRemoval(alien);
            this.increaseSpeed(INCREASE_MOVE_SPEED_PERCENT);
        }
    }
}

