/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import model.AnimatedEntity;
import model.BorderEntity;
import model.State;
import model.events.EntityEventListener;
import model.events.EntityHitEvent;

public class AlienEntity
extends AnimatedEntity
implements EntityEventListener {
    static List<String> alienDyingSpritesList = null;
    static List<String> alienAnimationSpritesList = null;
    static Clip soundWhenDying;
    private static final double MOVE_SPEED = 100.0;
    private static String ALIEN_SPRITE;
    public static final int ADVANCE_SPEED = 20;

    public AlienEntity(int x, int y) {
        super(ALIEN_SPRITE, x, y);
        this.dx = 100.0;
        this.dy = 0.0;
        if (alienDyingSpritesList == null) {
            alienDyingSpritesList = new LinkedList<String>();
            alienDyingSpritesList.add("explosion1.gif");
            alienDyingSpritesList.add("explosion2.gif");
            alienDyingSpritesList.add("explosion3.gif");
            alienDyingSpritesList.add("explosion4.gif");
            alienDyingSpritesList.add("explosion5.gif");
            alienDyingSpritesList.add("explosion6.gif");
            alienAnimationSpritesList = new LinkedList<String>();
            alienAnimationSpritesList.add("newalien1.gif");
            alienAnimationSpritesList.add("newalien2.gif");
            alienAnimationSpritesList.add("newalien3.gif");
            alienAnimationSpritesList.add("newalien4.gif");
            alienAnimationSpritesList.add("newalien5.gif");
            alienAnimationSpritesList.add("newalien6.gif");
            alienAnimationSpritesList.add("newalien7.gif");
            alienAnimationSpritesList.add("newalien8.gif");
            this.loadDyingSound();
        }
        this.setDyingSpritesList(alienDyingSpritesList);
        this.setAnimationSpritesList(alienAnimationSpritesList);
    }

    private void loadDyingSound() {
        URL url = this.getClass().getClassLoader().getResource("sounds/die.wav");
        try {
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
            soundWhenDying = AudioSystem.getClip();
            soundWhenDying.open(audioIn);
        }
        catch (Exception ex) {
            soundWhenDying = null;
        }
    }

    @Override
    public void collisionHasOccured(EntityHitEvent e) {
        if (e.getHitBy() instanceof BorderEntity) {
            BorderEntity border = (BorderEntity)e.getHitBy();
            if (border.getId().equals("RIGHT")) {
                this.moveTo(this.getX() - 10, this.getY() + 20);
                this.setHorizontalMovement(-this.getHorizontalMovement());
            } else if (border.getId().equals("LEFT")) {
                this.moveTo(this.getX() + 10, this.getY() + 20);
                this.setHorizontalMovement(-this.getHorizontalMovement());
            }
        } else {
            this.sound = soundWhenDying;
            this.setCurrentState(State.DYING);
        }
    }

    static {
        ALIEN_SPRITE = "newalien1.gif";
    }
}

