/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.List;
import model.Entity;

public abstract class AnimatedEntity
extends Entity {
    protected static final double ANIMATION_SPEED = 100.0;
    protected boolean animated = true;
    protected int currentMoveSprite = 0;
    protected int currentSprite;
    protected double millisLastRotated = System.currentTimeMillis();
    protected List<String> animationSpritesList;

    public List<String> getAnimationSpritesList() {
        return this.animationSpritesList;
    }

    public void setAnimationSpritesList(List<String> animationSpritesList) {
        this.animationSpritesList = animationSpritesList;
    }

    public void setAnimated(boolean value) {
        this.animated = value;
    }

    public AnimatedEntity(String ref, int x, int y) {
        super(ref, x, y);
    }

    @Override
    public void updateState(long delta) {
        switch (this.currentState) {
            case ALIVE: {
                if (!this.animated || this.animationSpritesList.size() <= 0 || !((double)System.currentTimeMillis() - this.millisLastRotated >= 100.0)) break;
                this.currentMoveSprite = (this.currentMoveSprite + 1) % this.animationSpritesList.size();
                this.setSprite(this.animationSpritesList.get(this.currentMoveSprite));
                this.millisLastRotated = System.currentTimeMillis();
                break;
            }
        }
        super.updateState(delta);
    }
}

