/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.Clip;
import model.Sprite;
import model.SpriteStore;
import model.State;
import model.events.EntityDiedEvent;
import model.events.EntityEventListener;
import model.events.EntityHitEvent;
import model.events.EntityMoveEvent;

public abstract class Entity
implements EntityEventListener {
    public static final String DEF_REF_TO_SPRITE_IMAGE_FILE = null;
    public static final int DEF_X = 0;
    public static final int DEF_Y = 0;
    public static final double LIFE_LEFT_TOLERANCE = 0.01;
    public static final double DEFAULT_DEATH_RATE = 0.002;
    protected double lifeLeft = 1.0;
    protected double x;
    protected double y;
    protected Sprite sprite;
    protected double dx;
    protected double dy;
    private transient List<EntityEventListener> entityEventListeners;
    protected State currentState = null;
    protected List<String> dyingSpritesList;
    protected Clip sound;
    protected boolean justEnteredState;
    protected boolean canMoveRight = true;
    protected boolean canMoveLeft = true;
    protected boolean canMoveUp = true;
    protected boolean canMoveDown = true;

    public Entity() {
        this(DEF_REF_TO_SPRITE_IMAGE_FILE, 0, 0);
    }

    public Entity(String refToSpriteImageFile, int x, int y) {
        this.sprite = refToSpriteImageFile != null ? SpriteStore.get().getSprite(refToSpriteImageFile) : null;
        this.x = x;
        this.y = y;
        this.addEntityEventListener(this);
        this.setCurrentState(State.ALIVE);
        this.dyingSpritesList = null;
        this.sound = null;
    }

    public Clip getSound() {
        return this.sound;
    }

    public void setSound(Clip sound) {
        this.sound = sound;
    }

    public List<String> getDyingSpritesList() {
        return this.dyingSpritesList;
    }

    public void setDyingSpritesList(List<String> dyingSpritesList) {
        this.dyingSpritesList = dyingSpritesList;
    }

    public void setHorizontalMovement(double dx) {
        this.dx = 0.0;
        if (dx > 0.0) {
            if (this.canMoveRight) {
                this.dx = dx;
                this.canMoveLeft = true;
            }
        } else if (dx < 0.0 && this.canMoveLeft) {
            this.dx = dx;
            this.canMoveRight = true;
        }
    }

    public void setVerticalMovement(double dy) {
        this.dy = 0.0;
        if (dy > 0.0) {
            if (this.canMoveDown) {
                this.dy = dy;
                this.canMoveUp = true;
            }
        } else if (dy < 0.0 && this.canMoveUp) {
            this.dy = dy;
            this.canMoveDown = true;
        }
    }

    public double getHorizontalMovement() {
        return this.dx;
    }

    public double getVerticalMovement() {
        return this.dy;
    }

    public int getX() {
        return (int)this.x;
    }

    public int getY() {
        return (int)this.y;
    }

    public double getLifeLeft() {
        return this.lifeLeft;
    }

    public void setLifeLeft(double lifeLeft) {
        this.lifeLeft = lifeLeft;
        Logger.getLogger("SpaceInvadersLog").log(Level.FINE, "New LifeLeft = {0}", lifeLeft);
        if (this.lifeLeft < 0.0 || Math.abs(this.lifeLeft - 0.0) <= 0.01) {
            this.fireEntityDied(new EntityDiedEvent(this));
        }
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public final void setCurrentState(State newState) {
        if (this.currentState != newState) {
            this.currentState = newState;
            this.justEnteredState = true;
        }
    }

    public void setSprite(String ref) {
        this.sprite = SpriteStore.get().getSprite(ref);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity ent = (Entity)obj;
        return ent.x == this.x && ent.y == this.y && ent.dx == this.dx && ent.dy == this.dy && ent.lifeLeft == this.lifeLeft && ent.sprite.equals(this.sprite) && ent.currentState == this.currentState;
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 41 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 41 * hash + (this.sprite != null ? this.sprite.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[x=");
        sb.append(this.x);
        sb.append(", y=");
        sb.append(this.y);
        sb.append(", dx=");
        sb.append(this.dx);
        sb.append(", dy=");
        sb.append(this.dy);
        sb.append("lifeLeft=");
        sb.append(this.lifeLeft);
        sb.append(", currentState=");
        sb.append((Object)this.currentState);
        sb.append(", dyingSpritesList=");
        sb.append(this.dyingSpritesList);
        sb.append(']');
        return sb.toString();
    }

    public void updateState(long delta) {
        if (this.justEnteredState && this.sound != null) {
            this.sound.setFramePosition(0);
            this.sound.start();
        }
        switch (this.currentState) {
            case ALIVE: {
                this.move(delta);
                break;
            }
            case DYING: {
                this.setLifeLeft(this.lifeLeft - (double)delta * 0.002);
                if (this.dyingSpritesList != null && this.dyingSpritesList.size() > 0) {
                    int spriteChoice = Math.abs((int)Math.round(this.lifeLeft * 10.0)) % this.dyingSpritesList.size();
                    Logger.getLogger("SpaceInvadersLog").log(Level.FINE, "spritChoice = {0}", spriteChoice);
                    this.setSprite(this.dyingSpritesList.get(spriteChoice));
                } else {
                    System.out.println("here");
                }
                this.move(delta);
                break;
            }
            case DEAD: {
                break;
            }
        }
        this.justEnteredState = false;
    }

    public void move(long delta) {
        if (delta == 0L || this.dx == 0.0 && this.dy == 0.0) {
            return;
        }
        this.x += (double)delta * (this.dx / 1000.0);
        this.y += (double)delta * (this.dy / 1000.0);
        this.fireEntityMoved(new EntityMoveEvent(this));
    }

    public void draw(Graphics g) {
        this.sprite.draw(g, (int)this.x, (int)this.y);
    }

    protected Rectangle collisionArea() {
        return new Rectangle((int)this.x, (int)this.y, this.sprite.getWidth(), this.sprite.getHeight());
    }

    public boolean collidesWith(Entity other) {
        if (this == other) {
            return false;
        }
        Rectangle him = other.collisionArea();
        Rectangle me = this.collisionArea();
        boolean collision = me.intersects(him);
        return collision;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
        this.fireEntityMoved(new EntityMoveEvent(this));
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public synchronized void removeEntityEventListener(EntityEventListener l) {
        this.entityEventListeners.remove(l);
    }

    public final synchronized void addEntityEventListener(EntityEventListener l) {
        if (this.entityEventListeners == null) {
            this.entityEventListeners = new ArrayList<EntityEventListener>(2);
        }
        if (!this.entityEventListeners.contains(l)) {
            this.entityEventListeners.add(l);
        }
    }

    public void fireCollisionHasOccured(EntityHitEvent e) {
        if (Logger.getLogger("SpaceInvadersLog").getLevel() == Level.FINE) {
            String infoStr = "[" + e.getHit().getClass() + "] HIT by [" + e.getHitBy().getClass() + "] and will inform " + this.entityEventListeners.size() + " listeners ";
            for (int i = 0; i < this.entityEventListeners.size(); ++i) {
                infoStr = infoStr + "[" + this.entityEventListeners.get(i).getClass() + "]";
            }
            Logger.getLogger("SpaceInvadersLog").log(Level.FINE, infoStr);
        }
        if (this.entityEventListeners != null) {
            List<EntityEventListener> listeners = this.entityEventListeners;
            int count = listeners.size();
            Logger.getLogger("SpaceInvadersLog").log(Level.FINEST, "\n *****************   Start of firing of collision events ");
            Logger.getLogger("SpaceInvadersLog").log(Level.FINEST, "Entity: {0}\n\tNumber of Listeners: {1} \n\tEntityHitEvent: {2}", new Object[]{this, count, e});
            for (int i = 0; i < count; ++i) {
                listeners.get(i).collisionHasOccured(e);
                Logger.getLogger("SpaceInvadersLog").log(Level.FINEST, "\tSent to listener {0} \n\t\t:listener: {1}", new Object[]{i, listeners.get(i)});
            }
            Logger.getLogger("SpaceInvadersLog").log(Level.FINEST, " *******************Finished firing of collision event\n ");
        }
    }

    protected void fireEntityMoved(EntityMoveEvent e) {
        int i;
        if (Logger.getLogger("SpaceInvadersLog").getLevel() == Level.FINEST) {
            String infoStr = "[" + e + "] MOVED and will inform " + this.entityEventListeners.size() + " listeners ";
            for (i = 0; i < this.entityEventListeners.size(); ++i) {
                infoStr = infoStr + "[" + this.entityEventListeners.get(i).getClass() + "]";
            }
            Logger.getLogger("SpaceInvadersLog").log(Level.FINEST, infoStr);
        }
        if (this.entityEventListeners != null) {
            int count = this.entityEventListeners.size();
            for (i = 0; i < count; ++i) {
                this.entityEventListeners.get(i).entityMoved(e);
            }
        }
    }

    protected void fireEntityDied(EntityDiedEvent e) {
        int i;
        if (Logger.getLogger("SpaceInvadersLog").getLevel() == Level.FINE) {
            String infoStr = "[" + e + "] DIED and will inform " + this.entityEventListeners.size() + " listeners ";
            for (i = 0; i < this.entityEventListeners.size(); ++i) {
                infoStr = infoStr + "[" + this.entityEventListeners.get(i).getClass() + "]";
            }
            Logger.getLogger("SpaceInvadersLog").log(Level.FINE, infoStr);
        }
        if (this.entityEventListeners != null) {
            int count = this.entityEventListeners.size();
            for (i = 0; i < count; ++i) {
                this.entityEventListeners.get(i).entityDied(e);
            }
        }
    }

    @Override
    public void collisionHasOccured(EntityHitEvent e) {
    }

    @Override
    public void entityMoved(EntityMoveEvent e) {
    }

    @Override
    public void entityDied(EntityDiedEvent e) {
        this.setCurrentState(State.DEAD);
    }
}

