/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.Graphics2D;
import model.Entity;
import model.EntityListInterface;
import model.events.EntityDiedEvent;
import model.events.EntityEventListener;
import model.events.EntityHitEvent;
import model.events.EntityMoveEvent;

public class EntityListArray
implements EntityListInterface,
EntityEventListener {
    public static final int MAX_SIZE = 100;
    protected Entity[] entities = new Entity[100];
    protected Entity[] removeEntities = new Entity[100];
    protected int numEntities = 0;
    protected int numRemoveEntities = 0;

    @Override
    public void clear() {
        this.entities = new Entity[100];
        this.removeEntities = new Entity[100];
        this.numEntities = 0;
        this.numRemoveEntities = 0;
    }

    @Override
    public void add(Entity e) {
        if (this.numEntities >= 100) {
            System.out.print("Entities cannot exceed: 100");
        } else {
            this.entities[this.numEntities] = e;
            ++this.numEntities;
            e.addEntityEventListener(this);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        for (int i = 0; i < this.numEntities; ++i) {
            this.entities[i].draw(g);
        }
    }

    @Override
    public void moveAndDraw(long delta, Graphics2D g) {
        for (int i = 0; i < this.numEntities; ++i) {
            this.entities[i].updateState(delta);
            this.entities[i].draw(g);
        }
    }

    @Override
    public void addEntityEventListener(EntityEventListener l) {
        for (int i = 0; i < this.numEntities; ++i) {
            this.entities[i].addEntityEventListener(l);
        }
    }

    @Override
    public void updateState(long delta) {
        int i;
        for (i = 0; i < this.numEntities; ++i) {
            this.entities[i].updateState(delta);
        }
        for (i = 0; i < this.numRemoveEntities; ++i) {
            this.remove(this.removeEntities[i]);
        }
        this.removeEntities = new Entity[100];
        this.numRemoveEntities = 0;
    }

    @Override
    public void increaseSpeed(int percentIncrease) {
        for (int i = 0; i < this.numEntities; ++i) {
            double Horizontal = this.entities[i].getHorizontalMovement();
            double Vertical = this.entities[i].getVerticalMovement();
            double newvalueh = (double)(percentIncrease / 100) * Horizontal;
            double newvaluev = (double)(percentIncrease / 100) * Vertical;
            this.entities[i].setHorizontalMovement(newvalueh + Horizontal);
            this.entities[i].setVerticalMovement(newvaluev + Vertical);
        }
    }

    @Override
    public Entity collidesWith(Entity other) {
        for (int i = 0; i < this.numEntities; ++i) {
            if (!this.entities[i].collidesWith(other)) continue;
            return this.entities[i];
        }
        return null;
    }

    @Override
    public void remove(Entity e) {
        Entity[] newArray = new Entity[100];
        int newNumEntities = 0;
        for (int i = 0; i < this.numEntities; ++i) {
            if (this.entities[i] == e) continue;
            newArray[newNumEntities] = this.entities[i];
            ++newNumEntities;
        }
        this.entities = newArray;
        this.numEntities = newNumEntities;
    }

    @Override
    public int getNumEntities() {
        return this.numEntities;
    }

    @Override
    public Entity getRandom() {
        if (this.entities[0] == null) {
            return null;
        }
        double random = Math.random() * (double)(this.numEntities - 1);
        int index = (int)random;
        return this.entities[index];
    }

    @Override
    public void registerEntityForRemoval(Entity e) {
        this.removeEntities[this.numRemoveEntities] = e;
        ++this.numRemoveEntities;
    }

    @Override
    public void collisionHasOccured(EntityHitEvent e) {
    }

    @Override
    public void entityMoved(EntityMoveEvent e) {
    }

    @Override
    public void entityDied(EntityDiedEvent e) {
        this.remove((Entity)e.getSource());
    }

    public String toString() {
        int i;
        String result = "";
        result = super.toString() + ", NumEntities = " + this.numEntities + ", NumRemoveEntities = " + this.numRemoveEntities;
        result = result + "\nEntites:";
        for (i = 0; i < this.numEntities; ++i) {
            result = result + "\n" + this.entities[i];
        }
        result = result + "\nRemoveEntities:";
        for (i = 0; i < this.numRemoveEntities; ++i) {
            result = result + "\n" + this.removeEntities[i];
        }
        return result;
    }
}

