/*
 * Decompiled with CFR 0.152.
 */
package model;

import dao.GameDetailsDAOText;
import java.io.Serializable;
import model.GameSettings;
import model.UserDetails;

public class GameDetails
implements Serializable {
    public static final int POINTS_GAINED_FOR_SHIP_DESTROYED = 100;
    public static final int POINTS_LOST_FOR_WASTED_SHOT = 50;
    private UserDetails userDetails;
    private GameSettings gameSettings;
    private int highScore;
    private int score;
    private int shipsDestroyed;
    private int shotsFired;
    private boolean newHighScore;

    public GameDetails() throws Exception {
        this(new UserDetails(), new GameSettings());
    }

    public GameDetails(UserDetails user, GameSettings gameSettings) throws Exception {
        this.userDetails = user;
        this.gameSettings = gameSettings;
        this.resetTheScoringDetails();
    }

    public void setUserDetails(UserDetails userDetails) {
        this.userDetails = userDetails;
    }

    public void setGameSettings(GameSettings gameSettings) {
        this.gameSettings = gameSettings;
    }

    public GameSettings getGameSettings() {
        return this.gameSettings;
    }

    public UserDetails getUserDetails() {
        return this.userDetails;
    }

    public void setHighScore(int score) {
        this.highScore = score;
    }

    public int getHighScore() {
        return this.highScore;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public int getScore() {
        return this.score;
    }

    public void setShipsDestroyed(int ships) {
        this.shipsDestroyed = ships;
    }

    public int getShipsDestroyed() {
        return this.shipsDestroyed;
    }

    public void setShotsFired(int shots) {
        this.shotsFired = shots;
    }

    public int getShotsFired() {
        return this.shotsFired;
    }

    public boolean isNewHighScore() {
        return this.newHighScore;
    }

    public void setNewHighScore(boolean newHighScore) {
        this.newHighScore = newHighScore;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[");
        sb.append("\nuserDetails = ");
        sb.append(this.userDetails);
        sb.append("\ngameSettings = ");
        sb.append(this.gameSettings);
        sb.append("\nhighScore = ");
        sb.append(this.highScore);
        sb.append("\nscore = ");
        sb.append(this.score);
        sb.append("\nshipsDestroyed = ");
        sb.append(this.shipsDestroyed);
        sb.append("\nshotsFired = ");
        sb.append(this.shotsFired);
        sb.append("\nnewHighScore = ");
        sb.append(this.newHighScore);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GameDetails)) {
            return false;
        }
        GameDetails game = (GameDetails)obj;
        return game.userDetails.equals(this.userDetails) && game.gameSettings.equals(this.gameSettings);
    }

    public int calculateScoreChanges() {
        int currentScore;
        int missedShots = this.shotsFired - this.shipsDestroyed;
        this.score = currentScore = this.shipsDestroyed * 100 - missedShots * 50;
        if (this.score > this.highScore) {
            this.newHighScore = true;
            this.highScore = this.score;
        } else {
            this.newHighScore = false;
        }
        if (currentScore < 0) {
            currentScore = 0;
        }
        return currentScore;
    }

    public final void resetTheScoringDetails() throws Exception {
        GameDetailsDAOText.saveHighScore(this);
        this.newHighScore = false;
        this.score = 0;
        this.shipsDestroyed = 0;
        this.shotsFired = 0;
        try {
            GameDetailsDAOText.loadHighScore(this);
        }
        catch (Exception ex) {
            this.highScore = 0;
        }
    }

    public void saveData() throws Exception {
        GameDetailsDAOText.saveData(this);
    }

    public void loadData() throws Exception {
        GameDetailsDAOText.loadData(this);
    }
}

