/*
 * Decompiled with CFR 0.152.
 */
package model;

import dao.GameSettingsDAOText;
import java.io.Serializable;
import model.UserDetails;

public class GameSettings
implements Serializable {
    public static final double MOVE_SPEED = 300.0;
    public static final int FIRING_INTERVAL = 700;
    private double moveSpeed;
    private int firingInterval;

    public GameSettings() {
        this(300.0, 700);
    }

    public GameSettings(double moveSpeed, int firingInterval) {
        this.moveSpeed = moveSpeed;
        this.firingInterval = firingInterval;
    }

    public double getMoveSpeed() {
        return this.moveSpeed;
    }

    public int getFiringInterval() {
        return this.firingInterval;
    }

    public void setMoveSpeed(double moveSpeed) {
        this.moveSpeed = moveSpeed;
    }

    public void setFiringInterval(int firingInterval) {
        this.firingInterval = firingInterval;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GameSettings)) {
            return false;
        }
        GameSettings game = (GameSettings)o;
        return game.getMoveSpeed() == this.getMoveSpeed() && game.getFiringInterval() == this.getFiringInterval();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[");
        sb.append("\nmoveSpeed = ");
        sb.append(this.moveSpeed);
        sb.append("\nfiringInterval = ");
        sb.append(this.firingInterval);
        sb.append(']');
        return sb.toString();
    }

    public void saveData(UserDetails user) throws Exception {
        GameSettingsDAOText.saveData(user, this);
    }

    public void loadData(UserDetails user) throws Exception {
        GameSettingsDAOText.loadData(user, this);
    }
}

