/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import model.BorderEntity;
import model.Entity;
import model.State;
import model.events.EntityEventListener;
import model.events.EntityHitEvent;

public class ShipEntity
extends Entity
implements EntityEventListener {
    static final List<String> DYING_SHIP_SPRITES_LIST = new LinkedList<String>();
    static Clip soundWhenDying;
    static final String SHIP_SPRITE = "ship.gif";

    public ShipEntity(int x, int y) {
        super(SHIP_SPRITE, x, y);
        if (DYING_SHIP_SPRITES_LIST.isEmpty()) {
            DYING_SHIP_SPRITES_LIST.add("explosion1.gif");
            DYING_SHIP_SPRITES_LIST.add("explosion2.gif");
            DYING_SHIP_SPRITES_LIST.add("explosion3.gif");
            DYING_SHIP_SPRITES_LIST.add("explosion4.gif");
            DYING_SHIP_SPRITES_LIST.add("explosion5.gif");
            DYING_SHIP_SPRITES_LIST.add("explosion6.gif");
        }
        this.setDyingSpritesList(DYING_SHIP_SPRITES_LIST);
        this.loadDyingSound();
    }

    private void loadDyingSound() {
        URL url = this.getClass().getClassLoader().getResource("sounds/die.wav");
        try {
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
            soundWhenDying = AudioSystem.getClip();
            soundWhenDying.open(audioIn);
        }
        catch (Exception ex) {
            Logger.getLogger("SpaceInvadersLog").log(Level.SEVERE, "Unable to load sound - sounds/die.wav. Continues with no sound.");
            soundWhenDying = null;
        }
    }

    @Override
    public void collisionHasOccured(EntityHitEvent e) {
        if (e.getHitBy() instanceof BorderEntity) {
            this.stopMovement(e);
        } else {
            this.setSound(soundWhenDying);
            this.setCurrentState(State.DYING);
        }
    }

    private void stopMovement(EntityHitEvent e) {
        BorderEntity theBorder = (BorderEntity)e.getHitBy();
        if (theBorder.getId().equals("RIGHT")) {
            this.setHorizontalMovement(0.0);
            this.canMoveRight = false;
        } else if (theBorder.getId().equals("LEFT")) {
            this.setHorizontalMovement(0.0);
            this.canMoveLeft = false;
        } else if (theBorder.getId().equals("BOTTOM")) {
            this.setVerticalMovement(0.0);
            this.canMoveDown = false;
        } else if (theBorder.getId().equals("TOP")) {
            this.setVerticalMovement(0.0);
            this.canMoveUp = false;
        }
    }
}

