/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import model.AnimatedEntity;
import model.events.EntityHitEvent;

public class ShotEntity
extends AnimatedEntity {
    private static final double DEF_MOVE_SPEED = -300.0;
    static List<String> shotAnimationSpritesList = null;
    static Clip soundWhenAlive;
    static final String SHOT_SPRITE = "shot.gif";

    public ShotEntity(int x, int y) {
        this(x, y, -300.0);
    }

    public ShotEntity(int x, int y, double yMoveSpeed) {
        super(SHOT_SPRITE, x, y);
        this.dy = yMoveSpeed;
        if (shotAnimationSpritesList == null) {
            shotAnimationSpritesList = new LinkedList<String>();
            shotAnimationSpritesList.add(SHOT_SPRITE);
            shotAnimationSpritesList.add("shot1.gif");
            this.loadAliveSound();
        }
        this.setAnimationSpritesList(shotAnimationSpritesList);
        this.setSound(soundWhenAlive);
    }

    private void loadAliveSound() {
        URL url = this.getClass().getClassLoader().getResource("sounds/shot.wav");
        try {
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
            soundWhenAlive = AudioSystem.getClip();
            soundWhenAlive.open(audioIn);
            soundWhenAlive.start();
        }
        catch (Exception ex) {
            soundWhenAlive = null;
        }
    }

    @Override
    public void collisionHasOccured(EntityHitEvent e) {
        this.setLifeLeft(0.0);
    }
}

