/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import model.Sprite;

public class SpriteStore {
    protected static String SPRITE_FOLDER = "sprites/";
    private static SpriteStore single = new SpriteStore();
    private HashMap<String, Sprite> sprites = new HashMap();

    public static SpriteStore get() {
        return single;
    }

    public Sprite getSprite(String ref) {
        if (this.sprites.get(ref) != null) {
            return this.sprites.get(ref);
        }
        BufferedImage sourceImage = null;
        try {
            URL url = this.getClass().getClassLoader().getResource(SPRITE_FOLDER + ref);
            if (url == null) {
                this.fail("Can't find ref: " + SPRITE_FOLDER + ref);
            }
            sourceImage = ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.fail("Failed to load: " + ref);
        }
        GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(sourceImage.getWidth(), sourceImage.getHeight(), 2);
        ((Image)image).getGraphics().drawImage(sourceImage, 0, 0, null);
        Sprite sprite = new Sprite(ref, image);
        this.sprites.put(ref, sprite);
        return sprite;
    }

    private void fail(String message) {
        System.err.println(message);
        Logger.getLogger("SpaceInvadersLog").log(Level.SEVERE, message);
    }
}

