/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class JDialogLogin
extends JDialog {
    private boolean loginCancelled = false;
    public static final int NEW = 1;
    public static final int EXISTING = 2;
    private ButtonGroup bgNewOrReturning;
    private JButton btnCancel;
    private JButton btnOK;
    private JLabel jLabError;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel lblRepeatPassword;
    private JPanel pnlNewOrReturning;
    private JPanel pnlPlayerDetails;
    private JRadioButton radNewPlayer;
    private JRadioButton radReturningPlayer;
    private JPasswordField txtPassword1;
    private JPasswordField txtPassword2;
    private JTextField txtUsername;

    public void displayDatabaseError() {
        this.jLabError.setText("A database error has occured. Try again later.");
        this.jLabError.setVisible(true);
    }

    public void displayUserAlreadyExistsError() {
        this.jLabError.setText("Username already in use. Please try again.");
        this.jLabError.setVisible(true);
    }

    public void displayUserDoesNotExistError() {
        this.jLabError.setText("Username does not exist. Please try again.");
        this.jLabError.setVisible(true);
    }

    public void displayWrongPasswordError() {
        this.jLabError.setText("Illegal password. Please try again.");
        this.jLabError.setVisible(true);
    }

    public JDialogLogin(Frame parent) {
        this(parent, true);
    }

    private JDialogLogin(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.rootPane.setDefaultButton(this.btnOK);
        this.setDefaultCloseOperation(0);
        this.setLoginViewType(2);
    }

    public String getUsername() {
        return this.txtUsername.getText();
    }

    public String getPassword() {
        return new String(this.txtPassword1.getPassword());
    }

    public boolean isLoginCancelled() {
        return this.loginCancelled;
    }

    private void displayMissingPasswordError() {
        this.jLabError.setText("Please enter a password");
        this.jLabError.setVisible(true);
    }

    private void displayPasswordReenterError() {
        this.jLabError.setText("Passwords don't match.");
        this.jLabError.setVisible(true);
    }

    private void initComponents() {
        this.bgNewOrReturning = new ButtonGroup();
        this.pnlNewOrReturning = new JPanel();
        this.radReturningPlayer = new JRadioButton();
        this.radNewPlayer = new JRadioButton();
        this.pnlPlayerDetails = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtUsername = new JTextField();
        this.txtPassword1 = new JPasswordField();
        this.txtPassword2 = new JPasswordField();
        this.lblRepeatPassword = new JLabel();
        this.btnCancel = new JButton();
        this.btnOK = new JButton();
        this.jLabError = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Login");
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setResizable(false);
        this.pnlNewOrReturning.setBorder(BorderFactory.createTitledBorder("Hi. Are you a New or Returning Player?"));
        this.bgNewOrReturning.add(this.radReturningPlayer);
        this.radReturningPlayer.setSelected(true);
        this.radReturningPlayer.setText("Returning Player");
        this.radReturningPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogLogin.this.radReturningPlayerActionPerformed(evt);
            }
        });
        this.bgNewOrReturning.add(this.radNewPlayer);
        this.radNewPlayer.setText("New Player");
        this.radNewPlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogLogin.this.radNewPlayerActionPerformed(evt);
            }
        });
        GroupLayout pnlNewOrReturningLayout = new GroupLayout((Container)this.pnlNewOrReturning);
        this.pnlNewOrReturning.setLayout((LayoutManager)pnlNewOrReturningLayout);
        pnlNewOrReturningLayout.setHorizontalGroup((GroupLayout.Group)pnlNewOrReturningLayout.createParallelGroup(1).add((GroupLayout.Group)pnlNewOrReturningLayout.createSequentialGroup().addContainerGap().add((Component)this.radReturningPlayer).add(18, 18, 18).add((Component)this.radNewPlayer).addContainerGap(-1, Short.MAX_VALUE)));
        pnlNewOrReturningLayout.setVerticalGroup((GroupLayout.Group)pnlNewOrReturningLayout.createParallelGroup(1).add((GroupLayout.Group)pnlNewOrReturningLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pnlNewOrReturningLayout.createParallelGroup(3).add((Component)this.radReturningPlayer).add((Component)this.radNewPlayer)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlPlayerDetails.setBorder(BorderFactory.createTitledBorder("New Player"));
        this.jLabel4.setText("Username:");
        this.jLabel5.setText("Password:");
        this.lblRepeatPassword.setText("Repeat Password:");
        GroupLayout pnlPlayerDetailsLayout = new GroupLayout((Container)this.pnlPlayerDetails);
        this.pnlPlayerDetails.setLayout((LayoutManager)pnlPlayerDetailsLayout);
        pnlPlayerDetailsLayout.setHorizontalGroup((GroupLayout.Group)pnlPlayerDetailsLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPlayerDetailsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pnlPlayerDetailsLayout.createParallelGroup(1).add((Component)this.txtUsername, -1, 224, Short.MAX_VALUE).add((Component)this.jLabel4).add((Component)this.jLabel5).add((Component)this.txtPassword1, -1, 224, Short.MAX_VALUE).add((Component)this.lblRepeatPassword).add((Component)this.txtPassword2, -1, 224, Short.MAX_VALUE)).addContainerGap()));
        pnlPlayerDetailsLayout.setVerticalGroup((GroupLayout.Group)pnlPlayerDetailsLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPlayerDetailsLayout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.txtUsername, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.txtPassword1, -2, -1, -2).addPreferredGap(0).add((Component)this.lblRepeatPassword).addPreferredGap(0).add((Component)this.txtPassword2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnCancel.setText("Cancel");
        this.btnCancel.setPreferredSize(new Dimension(73, 23));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogLogin.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOK.setText("OK");
        this.btnOK.setPreferredSize(new Dimension(73, 23));
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDialogLogin.this.btnOKActionPerformed(evt);
            }
        });
        this.jLabError.setForeground(new Color(255, 0, 51));
        this.jLabError.setText("                                    WELCOME");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(36, 36, 36).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.pnlNewOrReturning, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(100, 100, 100).add((Component)this.btnOK, -2, -1, -2).add(7, 7, 7).add((Component)this.btnCancel, -2, -1, -2)).add(1, (Component)this.pnlPlayerDetails, -2, -1, -2).add(1, (Component)this.jLabError, -2, 274, -2)).addContainerGap(25, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pnlNewOrReturning, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlPlayerDetails, -2, -1, -2).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.btnOK, -2, -1, -2).add((Component)this.btnCancel, -2, -1, -2)).add(18, 18, 18).add((Component)this.jLabError, -1, 28, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void setLoginViewType(int playerType) {
        if (playerType == 1) {
            this.txtPassword2.setVisible(true);
            this.lblRepeatPassword.setVisible(true);
            this.pnlPlayerDetails.setBorder(BorderFactory.createTitledBorder("New Player"));
        } else {
            this.txtPassword2.setVisible(false);
            this.lblRepeatPassword.setVisible(false);
            this.pnlPlayerDetails.setBorder(BorderFactory.createTitledBorder("Returning Player"));
        }
        this.txtUsername.requestFocus();
    }

    public int getPlayerType() {
        if (this.radNewPlayer.isSelected()) {
            return 1;
        }
        return 2;
    }

    private void radNewPlayerActionPerformed(ActionEvent evt) {
        this.setLoginViewType(1);
    }

    private void radReturningPlayerActionPerformed(ActionEvent evt) {
        this.setLoginViewType(2);
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        if (this.txtPassword1.getPassword().length == 0 || this.txtUsername.getText().equals("")) {
            this.displayMissingPasswordError();
            this.txtUsername.requestFocus();
        } else if (this.radNewPlayer.isSelected()) {
            String p2;
            String p1 = new String(this.txtPassword1.getPassword());
            if (!p1.equals(p2 = new String(this.txtPassword2.getPassword()))) {
                this.displayPasswordReenterError();
                this.txtPassword1.requestFocus();
            } else {
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.loginCancelled = true;
        this.setVisible(false);
    }
}

