/*
 * Decompiled with CFR 0.152.
 */
package view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import model.FiringIntervalComboBoxModel;
import model.GameDetails;
import model.MoveSpeedComboBoxModel;
import model.UserDetails;
import view.GameHighScoresView;
import view.IntroductionView;
import view.UserEvent;
import view.UserEventListener;
import view.UserViewInterface;
import view.UsersHighScoresView;

public class UserView
extends JPanel
implements UserViewInterface {
    private UserEventListener theController;
    private JFrame frameForWholeGame;
    private GameDetails currentGame;
    private JPanel jPanelCurrentGame = new JPanel();
    private JLabel jLabelShipsDes = new JLabel();
    private JTextField jTextFieldShipsDes = new JTextField(10);
    private JLabel jLabelCurrentScore = new JLabel();
    private JTextField jTextFieldCurrentScore = new JTextField(10);
    private JLabel jLabelShotsUsed = new JLabel();
    private JTextField jTextFieldShotsUsed = new JTextField(10);
    private JLabel jLabelMoveSpeed = new JLabel();
    private JTextField jTextFieldMoveSpeed = new JTextField(10);
    private JPanel jPanelGameSettings = new JPanel();
    private JLabel jLabelFiringInterval = new JLabel();
    private JTextField jTextFieldFiringInterval = new JTextField(10);
    private JLabel jLabelHighScore = new JLabel();
    private JTextField jTextFieldHighScore = new JTextField(10);
    private JPanel jPanelUserName = new JPanel();
    private JLabel jLabelUserName = new JLabel();
    private JTextField jTextFieldUserName = new JTextField(20);
    private JPanel jPanelButtons = new JPanel();
    private JPanel jPanelAction = new JPanel();
    private JPanel jPanelChange = new JPanel();
    private JButton jButtonPlayPause = new JButton();
    private JButton jButtonSave = new JButton();
    private JButton jButtonExit = new JButton();
    private JButton jButtonNewGame = new JButton();
    private JComboBox<Double> jComboSpeed = new JComboBox();
    private JComboBox<Integer> jComboFiringInterval = new JComboBox();
    private JButton jButtonInterval = new JButton();
    private JButton jButtonMyScores = new JButton();
    private JButton jButtonHighScores = new JButton();
    private JMenuBar jMenuBar = new JMenuBar();
    private JMenu jMenuFile = new JMenu("File");
    private JMenuItem jMenuItemNewGame = new JMenuItem("New Game");
    private JMenuItem jMenuItemSave = new JMenuItem("Save");
    private JMenuItem jMenuItemExit = new JMenuItem("Exit");
    private JMenu jMenuGame = new JMenu("Game");
    private JMenuItem jMenuItemPlayPause = new JMenuItem("Play Game");
    private JMenu jMenuSettings = new JMenu("Settings");
    private JMenuItem jMenuItemChangeMoveSpeed = new JMenuItem("Change Move Speed ...");
    private JMenuItem jMenuItemChangeFiringInterval = new JMenuItem("Change Firing Interval ...");
    private JMenuItem jMenuItemChangeWantIntroInfo = new JMenuItem("Turn off Intro Info ...");
    private MoveSpeedChangeEventHandler moveSpeedChangeHandler;
    private FiringIntervalChangeEventHandler firingIntervalChangeHandler;

    public UserView(JFrame pFrameForWholeGame) {
        try {
            this.frameForWholeGame = pFrameForWholeGame;
            this.initialiseComponents();
            pFrameForWholeGame.setLocationByPlatform(true);
        }
        catch (Exception ex) {
            Logger.getLogger("SpaceInvadersLog").log(Level.SEVERE, "Could not create the View", ex);
        }
    }

    private void initialiseComponents() throws Exception {
        this.setLayout(new BoxLayout(this, 1));
        this.jLabelUserName.setText("User Name      ");
        this.jTextFieldUserName.setText("TEST USER");
        this.jTextFieldUserName.setEditable(false);
        this.jPanelUserName.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jPanelUserName.setLayout(new FlowLayout(1));
        this.jPanelUserName.add(this.jLabelUserName);
        this.jPanelUserName.add(this.jTextFieldUserName);
        this.jLabelShipsDes.setText("Ships Destroyed");
        this.jTextFieldShipsDes.setText("");
        this.jTextFieldShipsDes.setEditable(false);
        this.jLabelShotsUsed.setText("Shots Used     ");
        this.jTextFieldShotsUsed.setText("");
        this.jTextFieldShotsUsed.setEditable(false);
        this.jLabelCurrentScore.setText("Current Score ");
        this.jTextFieldCurrentScore.setText("0");
        this.jTextFieldCurrentScore.setEditable(false);
        this.jPanelCurrentGame.add(this.jLabelShipsDes);
        this.jPanelCurrentGame.add(this.jTextFieldShipsDes);
        this.jPanelCurrentGame.add(this.jLabelShotsUsed);
        this.jPanelCurrentGame.add(this.jTextFieldShotsUsed);
        this.jPanelCurrentGame.add(this.jLabelCurrentScore);
        this.jPanelCurrentGame.add(this.jTextFieldCurrentScore);
        this.jLabelMoveSpeed.setText("Move Speed      ");
        this.jTextFieldMoveSpeed.setText(new Double(300.0).toString());
        this.jTextFieldMoveSpeed.setEditable(false);
        this.jLabelFiringInterval.setText("Firing Interval");
        this.jTextFieldFiringInterval.setText(new Integer(700).toString());
        this.jTextFieldFiringInterval.setEditable(false);
        this.jLabelHighScore.setText("High Score     ");
        this.jTextFieldHighScore.setText("0");
        this.jTextFieldHighScore.setEditable(false);
        this.jPanelGameSettings.add(this.jLabelMoveSpeed);
        this.jPanelGameSettings.add(this.jTextFieldMoveSpeed);
        this.jPanelGameSettings.add(this.jLabelFiringInterval);
        this.jPanelGameSettings.add(this.jTextFieldFiringInterval);
        this.jPanelGameSettings.add(this.jLabelHighScore);
        this.jPanelGameSettings.add(this.jTextFieldHighScore);
        this.jButtonPlayPause.setText("Play Game");
        this.jButtonSave.setText("Save Game Details");
        this.jButtonExit.setText("Exit");
        this.jButtonNewGame.setText("New Game");
        this.jComboSpeed.setModel(new MoveSpeedComboBoxModel());
        this.jComboFiringInterval.setModel(new FiringIntervalComboBoxModel());
        this.jButtonMyScores.setText("My Scores");
        this.jButtonHighScores.setText("Game High Scores");
        this.jPanelAction.setBorder(BorderFactory.createTitledBorder("ACTION"));
        this.jPanelAction.add((Component)this.jButtonPlayPause, null);
        this.jPanelAction.add((Component)this.jButtonSave, null);
        this.jPanelAction.add((Component)this.jButtonExit, null);
        this.jPanelAction.add((Component)this.jButtonNewGame, null);
        this.jPanelAction.add((Component)this.jButtonMyScores, null);
        this.jPanelAction.add((Component)this.jButtonHighScores, null);
        this.jPanelChange.setBorder(BorderFactory.createTitledBorder("CHANGE"));
        this.jPanelChange.add(new JLabel("Speed"));
        this.jPanelChange.add(this.jComboSpeed);
        this.jPanelChange.add(new JLabel("Interval"));
        this.jPanelChange.add(this.jComboFiringInterval);
        this.jPanelButtons.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jPanelButtons.add(this.jPanelAction);
        this.jPanelButtons.add(this.jPanelChange);
        this.jMenuFile.add(this.jMenuItemNewGame);
        this.jMenuFile.add(this.jMenuItemSave);
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuGame.add(this.jMenuItemPlayPause);
        this.jMenuSettings.add(this.jMenuItemChangeMoveSpeed);
        this.jMenuSettings.add(this.jMenuItemChangeFiringInterval);
        this.jMenuSettings.add(this.jMenuItemChangeWantIntroInfo);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuBar.add(this.jMenuGame);
        this.jMenuBar.add(this.jMenuSettings);
        this.frameForWholeGame.setJMenuBar(this.jMenuBar);
        this.add(this.jPanelUserName);
        this.add(this.jPanelCurrentGame);
        this.add(this.jPanelGameSettings);
        this.add(this.jPanelButtons);
        this.jButtonPlayPause.addActionListener(new PlayPauseEventHandler());
        this.jButtonSave.addActionListener(new SaveEventHandler());
        this.jButtonExit.addActionListener(new ExitEventHandler());
        this.jButtonNewGame.addActionListener(new NewGameEventHandler());
        this.jButtonInterval.addActionListener(new FiringIntervalChangeEventHandler());
        this.moveSpeedChangeHandler = new MoveSpeedChangeEventHandler();
        this.jComboSpeed.addActionListener(this.moveSpeedChangeHandler);
        this.firingIntervalChangeHandler = new FiringIntervalChangeEventHandler();
        this.jComboFiringInterval.addActionListener(this.firingIntervalChangeHandler);
        this.jButtonMyScores.addActionListener(new MyScoresEventHandler());
        this.jButtonHighScores.addActionListener(new HighScoresEventHandler());
        this.jMenuItemNewGame.addActionListener(new NewGameEventHandler());
        this.jMenuItemSave.addActionListener(new SaveEventHandler());
        this.jMenuItemExit.addActionListener(new ExitEventHandler());
        this.jMenuItemPlayPause.addActionListener(new PlayPauseEventHandler());
        this.jMenuItemChangeMoveSpeed.addActionListener(new MoveSpeedChangeEventHandler());
        this.jMenuItemChangeFiringInterval.addActionListener(new FiringIntervalChangeEventHandler());
        this.jMenuItemChangeWantIntroInfo.addActionListener(new WantIntroInfoChangeEventHandler());
        this.jButtonPlayPause.requestFocus();
    }

    @Override
    public GameDetails getCurrentGame() {
        return this.currentGame;
    }

    @Override
    public void setCurrentGame(GameDetails currentGame) {
        this.currentGame = currentGame;
    }

    @Override
    public void displayUsersHighScores(UserDetails theUser, List<GameDetails> highScores) {
        UsersHighScoresView highScoresView = new UsersHighScoresView(highScores, this.frameForWholeGame);
        highScoresView.setModal(true);
        highScoresView.setVisible(true);
    }

    @Override
    public void displayAllHighScores(List<GameDetails> highScores) {
        GameHighScoresView allHighScoresView = new GameHighScoresView(highScores, this.frameForWholeGame);
        allHighScoresView.setModal(true);
        allHighScoresView.setVisible(true);
    }

    @Override
    public void notifyNewHighScore() {
        JOptionPane.showMessageDialog(this, "WELL DONE!\n\nA New Personal High Score.\n(Wonder if it is a game high score?)\n");
    }

    @Override
    public void notifyWin() {
        JOptionPane.showMessageDialog(this, "Got them that time!\n\n");
    }

    @Override
    public void notifyDeath() {
        JOptionPane.showMessageDialog(this, "Too late!\n\nYou're dead!\n\n");
    }

    @Override
    public boolean confirmResetGame() {
        return JOptionPane.showConfirmDialog(this, "WARNING! Changing game settings will reset the current game.\n\nDo you want to continue?", "Warning", 2) == 0;
    }

    @Override
    public void displayIntroductionInfo() {
        IntroductionView info = new IntroductionView(this.frameForWholeGame, this.theController);
        info.setVisible(true);
    }

    @Override
    public void setUpForNewGame(GameDetails newGame) {
        this.jButtonPlayPause.setText("Play Game");
        this.jMenuItemPlayPause.setText("Play Game");
        this.setCurrentGame(newGame);
        this.displayGameDetails();
    }

    @Override
    public void displayGameDetails() {
        this.jTextFieldShipsDes.setText(new Integer(this.currentGame.getShipsDestroyed()).toString());
        this.jTextFieldShotsUsed.setText(new Integer(this.currentGame.getShotsFired()).toString());
        this.jTextFieldCurrentScore.setText(new Integer(this.currentGame.calculateScoreChanges()).toString());
        DecimalFormat df = new DecimalFormat("#0");
        this.jTextFieldFiringInterval.setText(Integer.toString(this.currentGame.getGameSettings().getFiringInterval()));
        this.jTextFieldMoveSpeed.setText(df.format(this.currentGame.getGameSettings().getMoveSpeed()));
        this.jTextFieldHighScore.setText(Integer.toString(this.currentGame.getHighScore()));
        this.jTextFieldUserName.setText(this.currentGame.getUserDetails().getUserName());
        this.jComboFiringInterval.setSelectedItem(this.currentGame.getGameSettings().getFiringInterval());
        this.firingIntervalChangeHandler.setOldInterval(this.currentGame.getGameSettings().getFiringInterval());
        this.jComboSpeed.setSelectedItem(this.currentGame.getGameSettings().getMoveSpeed());
        this.moveSpeedChangeHandler.setOldSpeed(this.currentGame.getGameSettings().getMoveSpeed());
    }

    @Override
    public void displaySaveGameSettingsError() {
        JOptionPane.showMessageDialog(this, "Unable to save to Database.");
    }

    @Override
    public void displayErrorDatabaseConnectionLost() {
        JOptionPane.showMessageDialog(this, "Unable to connect to database.\nWill be using default game settings and \nyou will be unable to save your score.");
        this.adjustInterfaceOptionsDueToLostDatabseConnection();
    }

    @Override
    public void displayErrorLoadingSounds() {
        JOptionPane.showMessageDialog(this, "Seems there is a problem loading the game sounds.\n");
    }

    @Override
    public void displayErrorUnableToLoadUserDetails(String userName) {
        if (userName.equals("NO NAME")) {
            JOptionPane.showMessageDialog(this, "Unable to load data from Database.");
        } else {
            JOptionPane.showMessageDialog(this, "Unable to load data from Database for user " + userName + ".");
        }
        this.adjustInterfaceOptionsDueToLostDatabseConnection();
    }

    private void adjustInterfaceOptionsDueToLostDatabseConnection() {
        this.jButtonMyScores.setEnabled(false);
        this.jButtonSave.setEnabled(false);
        this.jButtonHighScores.setEnabled(false);
        this.jMenuItemSave.setEnabled(false);
    }

    @Override
    public void setController(UserEventListener theController) {
        this.theController = theController;
    }

    @Override
    public void notifyGameOver() {
        JOptionPane.showMessageDialog(this, "\nYOUR GAME IS OVER!\n");
    }

    @Override
    public void displayErrorUnableToSaveUserDetails(String specificMessage) {
        JOptionPane.showMessageDialog(this, "User Setting update error - " + specificMessage + ".");
    }

    @Override
    public void adjustInterfaceOptionsDueToWantingIntroInfoChange(boolean wantIntroInfo) {
        if (wantIntroInfo) {
            this.jMenuItemChangeWantIntroInfo.setText("Turn off Intro Info ...");
        } else {
            this.jMenuItemChangeWantIntroInfo.setText("Turn on Intro Info ...");
        }
    }

    class PlayPauseEventHandler
    implements ActionListener {
        PlayPauseEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (UserView.this.jButtonPlayPause.getText().equals("PAUSE")) {
                UserView.this.jButtonPlayPause.setText("Play Game");
                UserView.this.jMenuItemPlayPause.setText("Play Game");
                UserView.this.theController.pauseGame(new UserEvent(this));
            } else {
                UserView.this.jButtonPlayPause.setText("PAUSE");
                UserView.this.jMenuItemPlayPause.setText("PAUSE");
                UserView.this.theController.startPlaying(new UserEvent(this));
            }
        }
    }

    class SaveEventHandler
    implements ActionListener {
        SaveEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserView.this.theController.saveCurrentGameResults(new UserEvent(this));
        }
    }

    class ExitEventHandler
    implements ActionListener {
        ExitEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserView.this.theController.exitGame(new UserEvent(this));
        }
    }

    class NewGameEventHandler
    implements ActionListener {
        NewGameEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserView.this.theController.setUpForNewGame();
        }
    }

    class FiringIntervalChangeEventHandler
    implements ActionListener {
        private Integer oldInterval = 0;

        FiringIntervalChangeEventHandler() {
        }

        public Integer getOldInterval() {
            return this.oldInterval;
        }

        public void setOldInterval(Integer oldInterval) {
            this.oldInterval = oldInterval;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserView.this.jComboFiringInterval.transferFocus();
            Integer interval = (Integer)UserView.this.jComboFiringInterval.getSelectedItem();
            if (!interval.equals(this.oldInterval) && UserView.this.theController != null) {
                if (UserView.this.confirmResetGame()) {
                    this.oldInterval = interval;
                    UserView.this.theController.changeFiringInterval(new UserEvent((Object)this, interval));
                }
                UserView.this.jComboFiringInterval.setSelectedItem(this.oldInterval);
            }
        }
    }

    class MoveSpeedChangeEventHandler
    implements ActionListener {
        private Double oldSpeed = 0.0;

        MoveSpeedChangeEventHandler() {
        }

        public Double getOldSpeed() {
            return this.oldSpeed;
        }

        public void setOldSpeed(Double oldSpeed) {
            this.oldSpeed = oldSpeed;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Double speed = (Double)UserView.this.jComboSpeed.getSelectedItem();
            UserView.this.jComboSpeed.transferFocus();
            if (!speed.equals(this.oldSpeed) && UserView.this.theController != null) {
                if (UserView.this.confirmResetGame()) {
                    this.oldSpeed = speed;
                    UserView.this.theController.changeMoveSpeed(new UserEvent((Object)this, speed));
                }
                UserView.this.jComboSpeed.setSelectedItem(this.oldSpeed);
            }
        }
    }

    class MyScoresEventHandler
    implements ActionListener {
        MyScoresEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                UserView.this.theController.getUsersHighScores(new UserEvent((Object)this, UserView.this.jTextFieldUserName.getText()));
            }
            catch (Exception ex) {
                Logger.getLogger(UserView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    class HighScoresEventHandler
    implements ActionListener {
        HighScoresEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserView.this.theController.getAllHighScores();
        }
    }

    private class WantIntroInfoChangeEventHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem choice = (JMenuItem)e.getSource();
            if (choice.getText().equals("Turn off Intro Info ...")) {
                UserView.this.theController.changeSettingForWantingIntroInfo(false);
            } else {
                UserView.this.theController.changeSettingForWantingIntroInfo(true);
            }
        }
    }

    class UndoSaveEventHandler
    implements ActionListener {
        UndoSaveEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UserView.this.theController.undoLastSave(new UserEvent(this));
        }
    }
}

